-- Testing PROCEDURE "plan in cache" vs. "plan just for THAT execution"
exec getmember 'tripp'						-- gets the plan in cache
exec getmember 'tripp' with recompile		-- gets a plan just for THIS execution

-- Testing FORCED STATEMENT "plan in cache" vs. "plan just for THAT execution"
sp_executesql statement						-- gets the plan in cache
sp_executesql statement OPTION (RECOMPILE)	-- gets a plan just for THIS execution

-- Isolate columns to ONE side of an expression

--Scenario: customers table with birthday column being compared to a LITERAL of the partydate
-- Imagine party on December 31, 2018...
-- To attend you must have been born ON or BEFORE December 31, 1997 (what??? is that right?)

SELECT dateadd(yy, -21, '20181231') -->>> Yep, 1997 (now I really feel old ;-)

--So....
SELECT * FROM customers
WHERE dateadd (yy, -21, '20181231') >= birthday -- IS seekable / optimal as the COLUMN is isolated

SELECT * FROM customers
WHERE dateadd (yy, 21, birthday) <= '20181231' -- IS NOT seekable as the column has a computation